const Encore = require('@symfony/webpack-encore');

// Manually configure the runtime environment if not already configured yet by the "encore" command.
// It's useful when you use tools that rely on webpack.config.js file.
if (!Encore.isRuntimeEnvironmentConfigured()) {
    Encore.configureRuntimeEnvironment(process.env.NODE_ENV || 'dev');
}



Encore
    .setOutputPath('public/build/cms')
    .setPublicPath('/build/cms')
    .addEntry('cms', './assets/app.js')
    .enableStimulusBridge('./assets/controllers.json')
    .splitEntryChunks()
    .enableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableBuildNotifications()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction())
    .configureBabelPresetEnv((config) => {
        config.useBuiltIns = 'usage';
        config.corejs = '3.23';
    })
    .enableSassLoader()
    .enableReactPreset()
;
const adminConfig = Encore.getWebpackConfig();
adminConfig.name = 'cms';
Encore.reset();

Encore
    .setOutputPath('public/build/portal')
    .setPublicPath('/build/portal')
    .addEntry('portal', './assets/portal.js')
    .enableStimulusBridge('./assets/portal_controllers.json')
    .splitEntryChunks()
    .enableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableBuildNotifications()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction())
    .configureBabelPresetEnv((config) => {
        config.useBuiltIns = 'usage';
        config.corejs = '3.23';
    })
    .enableSassLoader()
;
const portalConfig = Encore.getWebpackConfig();
portalConfig.name = 'portal';

module.exports = [adminConfig,portalConfig];
