<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\ZendeskClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class ZendeskProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        $node
            ->scalarNode('subdomain')
                ->isRequired()
                ->info('Your Zendesk subdomain')
            ->end()
        ;
    }

    public function getProviderClass(array $config)
    {
        return 'Stevenmaguire\OAuth2\Client\Provider\Zendesk';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
            'subdomain' => $config['subdomain'],
        ];
    }

    public function getPackagistName()
    {
        return 'stevenmaguire/oauth2-zendesk';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/stevenmaguire/oauth2-zendesk';
    }

    public function getProviderDisplayName()
    {
        return 'Zendesk';
    }

    public function getClientClass(array $config)
    {
        return ZendeskClient::class;
    }
}
