<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\YahooClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class YahooProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'Hayageek\OAuth2\Client\Provider\Yahoo';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'hayageek/oauth2-yahoo';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/hayageek/oauth2-yahoo';
    }

    public function getProviderDisplayName()
    {
        return 'Yahoo';
    }

    public function getClientClass(array $config)
    {
        return YahooClient::class;
    }
}
