<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\VimeoClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class VimeoProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'Saf33r\OAuth2\Client\Provider\Vimeo';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'saf33r/oauth2-vimeo';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/saf33r/oauth2-vimeo';
    }

    public function getProviderDisplayName()
    {
        return 'Vimeo';
    }

    public function getClientClass(array $config)
    {
        return VimeoClient::class;
    }
}
