<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\VKontakteClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class VKontakteProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'J4k\OAuth2\Client\Provider\Vkontakte';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'j4k/oauth2-vkontakte';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/j4k/oauth2-vkontakte';
    }

    public function getProviderDisplayName()
    {
        return 'VKontakte';
    }

    public function getClientClass(array $config)
    {
        return VKontakteClient::class;
    }
}
