<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\PsnClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class PsnProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'League\OAuth2\Client\Provider\Psn';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'larabros/oauth2-psn';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/larabros/oauth2-psn';
    }

    public function getProviderDisplayName()
    {
        return 'PSN';
    }

    public function getClientClass(array $config)
    {
        return PsnClient::class;
    }
}
