<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\PaypalClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class PaypalProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        $node
            ->booleanNode('is_sandbox')
                ->defaultFalse()
                ->info('When true, client uses Paypal Sandbox URLs.')
            ->end()
        ;
    }

    public function getProviderClass(array $config)
    {
        return 'Stevenmaguire\OAuth2\Client\Provider\Paypal';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
            'isSandbox' => $config['is_sandbox'],
        ];
    }

    public function getPackagistName()
    {
        return 'stevenmaguire/oauth2-paypal';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/stevenmaguire/oauth2-paypal';
    }

    public function getProviderDisplayName()
    {
        return 'Paypal';
    }

    public function getClientClass(array $config)
    {
        return PaypalClient::class;
    }
}
