<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\MollieClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class MollieProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'Mollie\OAuth2\Client\Provider\Mollie';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'mollie/oauth2-mollie-php';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/mollie/oauth2-mollie-php';
    }

    public function getProviderDisplayName()
    {
        return 'Mollie';
    }

    public function getClientClass(array $config)
    {
        return MollieClient::class;
    }
}
