<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\DigitalOceanClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class DigitalOceanProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'ChrisHemmings\OAuth2\Client\Provider\DigitalOcean';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'chrishemmings/oauth2-digitalocean';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/chrishemmings/oauth2-digitalocean';
    }

    public function getProviderDisplayName()
    {
        return 'DigitalOcean';
    }

    public function getClientClass(array $config)
    {
        return DigitalOceanClient::class;
    }
}
