<?php

/*
 * OAuth2 Client Bundle
 * Copyright (c) KnpUniversity <http://knpuniversity.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace KnpU\OAuth2ClientBundle\DependencyInjection\Providers;

use KnpU\OAuth2ClientBundle\Client\Provider\AmazonClient;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;

class AmazonProviderConfigurator implements ProviderConfiguratorInterface
{
    public function buildConfiguration(NodeBuilder $node)
    {
        // no custom options
    }

    public function getProviderClass(array $config)
    {
        return 'Luchianenco\OAuth2\Client\Provider\Amazon';
    }

    public function getProviderOptions(array $config)
    {
        return [
            'clientId' => $config['client_id'],
            'clientSecret' => $config['client_secret'],
        ];
    }

    public function getPackagistName()
    {
        return 'luchianenco/oauth2-amazon';
    }

    public function getLibraryHomepage()
    {
        return 'https://github.com/luchianenco/oauth2-amazon';
    }

    public function getProviderDisplayName()
    {
        return 'Amazon';
    }

    public function getClientClass(array $config)
    {
        return AmazonClient::class;
    }
}
