<?php

declare(strict_types=1);

namespace App\Validator\Constraints;

use Attribute;
use Symfony\Component\Validator\Constraints as Assert;

#[Attribute]
final class Password extends Assert\Compound
{
    protected function getConstraints(array $options): array
    {
        return [
            new Assert\Sequentially([
                new Assert\NotBlank(),
                new Assert\Type('string'),
                new Assert\Length(min: 8, max: 32),
                new Assert\Regex(pattern: '/^.*[a-z]+.*$/', message: 'Password must contain the following: 1 lower case character, 1 upper case character, 1 number1'),
                new Assert\Regex(pattern: '/^.*[A-Z]+.*$/', message: 'Password must contain the following: 1 lower case character, 1 upper case character, 1 number2'),
                new Assert\Regex(pattern: '/^.*[0-9]+.*$/', message: 'Password must contain the following: 1 lower case character, 1 upper case character, 1 number3'),
            ])
        ];
    }
}
