<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Shared;

use App\DTO\PublicAPI\Shared\Output\Meta;
use App\Entity\Common\Meta\Meta as MetaEntity;

final readonly class MetaTransformer
{
    public function __invoke(MetaEntity $metaEntity): Meta
    {
        return new Meta(
            $metaEntity->getTitle(),
            $metaEntity->getSiteName(),
            $metaEntity->getDescription(),
            $metaEntity->getKeywords()
        );
    }
}
