<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Shared;

use App\DTO\PublicAPI\Shared\Output\Address;
use App\Entity\Common\Address as AddressEntity;

final readonly class AddressTransformer
{
    public function __invoke(AddressEntity $addressEntity): Address
    {
        return new Address(
            $addressEntity->getId(),
            $addressEntity->getType(),
            $addressEntity->getCountry(),
            $addressEntity->getZip(),
            $addressEntity->getCity(),
            $addressEntity->getStreet(),
            $addressEntity->getStreetType(),
            $addressEntity->getHouseNumber(),
            $addressEntity->getBuilding(),
            $addressEntity->getFloor(),
            $addressEntity->getDoor()
        );
    }
}
