<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Page;

use App\DTO\PublicAPI\Page\PageDetails;
use App\Entity\Common\Meta\Meta;
use App\Entity\System\Page\Page;
use App\Transformer\DTO\Shared\MetaTransformer;

final readonly class PageDetailsTransformer
{
    public function __construct(
        private MetaTransformer  $metaTransformer,
    )
    {
    }

    public function __invoke(Page $page): PageDetails
    {
        $metaTransformer = $this->metaTransformer;
        $meta = $page->getMeta() instanceof Meta ? $metaTransformer($page->getMeta()) : null;

        return new PageDetails(
            $page->getId(),
            $page->getTitle(),
            $page->getSlug(),
            $meta,
            $page->getContent()
        );
    }
}
