<?php

declare(strict_types=1);

namespace App\Transformer\DTO\Article;

use App\DTO\PublicAPI\Article\Output\ArticleDetails;
use App\Entity\Common\Meta\Meta;
use App\Entity\Magazine\Article\Article;
use App\Transformer\DTO\Shared\MediaTransformer;
use App\Transformer\DTO\Shared\MetaTransformer;

final readonly class ArticleDetailsTransformer
{
    public function __construct(
        private MediaTransformer $mediaTransformer,
        private MetaTransformer  $metaTransformer,
    )
    {
    }

    public function __invoke(Article $article): ArticleDetails
    {
        $metaTransformer = $this->metaTransformer;

        $media = $this->mediaTransformer->create($article->getImage());
        $meta = $article->getMeta() instanceof Meta ? $metaTransformer($article->getMeta()) : null;

        return new ArticleDetails(
            $article->getId(),
            $article->getTitle(),
            $article->getIntro(),
            $article->getSlug(),
            $article->isHighlighted(),
            $article->getPublishedAt(),
            $media,
            $meta,
            $article->getContent()
        );
    }
}
