<?php

namespace App\Traits\Repository;

use App\Entity\Interfaces\TranslatableInterface;
use App\Entity\Shared\AbstractEntity;

trait Editable
{
    public function add(AbstractEntity $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);
        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function save(): void
    {
        $this->getEntityManager()->flush();
    }

    public function remove(AbstractEntity $entity, bool $flush = false): void
    {
        if (method_exists($entity, 'getIsActive')) {
            $entity->setIsActive(false);
            $entity->setIsHighlighted(false);
            $this->getEntityManager()->persist($entity);

            if ($flush) {
                $this->getEntityManager()->flush();
            }
        }

        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function restore(AbstractEntity $entity, bool $flush = false): void
    {
        $entity->setDeletedAt(null);

        if ($entity instanceof TranslatableInterface) {
            foreach ($entity->getTranslations() as $translation) {
                $translation->setDeletedAt(null);
                $this->getEntityManager()->persist($entity);
            }
        }

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }
}
