<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

trait NameAware
{
    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $firstName = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $lastName = null;

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getFullName(): ?string
    {
        $firstName = $this->firstName;
        $lastName = $this->lastName;
        return ($this->locale == 'hu') ? $lastName . ' ' . $firstName : $firstName . ' ' . $lastName;
    }
}
