<?php

declare(strict_types=1);

namespace App\Traits\Entity;

use App\Entity\Common\Layout\Block;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

trait Blockable
{
    protected ?Collection $blocks = null;

    public function getBlocks(): ?Collection
    {
        return $this->blocks;
    }

    public function addBlock(Block $block): self
    {
        if ($this->blocks === null) {
            $this->blocks = new ArrayCollection();
        }

        if (!$this->blocks->contains($block)) {
            $this->blocks->add($block);
        }

        return $this;
    }

    public function removeBlock(Block $block): self
    {
        $this->blocks->removeElement($block);

        return $this;
    }
}
