<?php

declare(strict_types=1);

namespace App\Traits\DTO;

use App\Enum\Shared\AddressType;
use Symfony\Component\Validator\Constraints as Assert;

trait AddressProperties
{
    #[Assert\Sequentially([
        new Assert\NotBlank(),
    ])]
    public AddressType $type;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string')
    ])]
    public $country;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string')
    ])]
    public $zip;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string')
    ])]
    public $city;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string')
    ])]
    public $street;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string')
    ])]
    public $streetType;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string')
    ])]
    public $houseNumber;

    #[Assert\Sequentially([
        new Assert\Type('string')
    ])]
    public $building;

    #[Assert\Sequentially([
        new Assert\Type('string')
    ])]
    public $floor;

    #[Assert\Sequentially([
        new Assert\Type('string')
    ])]
    public $door;

}
