<?php

declare(strict_types=1);

namespace App\Table\System;

use App\Table\Abstract\BaseTable;
use Omines\DataTablesBundle\Column\TextColumn;
use Omines\DataTablesBundle\DataTable;

final class AdministratorTable extends BaseTable
{
    public function configure(DataTable $dataTable, array $options): void
    {
        $dataTable
            ->add('name', TextColumn::class, [
                'render' => fn($value, $context): string => $this->twig->render('system/components/table/_blamable.html.twig', [
                    'meta' => ['route_prefix' => $options['prefix']],
                    'user' => $context
                ]),
                'searchable' => false,
                'orderable' => false
            ])
            ->add('firstName', TextColumn::class, ['visible' => false])
            ->add('lastName', TextColumn::class, ['visible' => false])
            ->add('email', TextColumn::class);

        parent::configure($dataTable, $options);
    }
}
