<?php

declare(strict_types=1);

namespace App\Table\System;

use App\Table\Abstract\BaseTable;
use Omines\DataTablesBundle\Column\TextColumn;
use Omines\DataTablesBundle\DataTable;

final class AddressTable extends BaseTable
{
    public function configure(DataTable $dataTable, array $options): void
    {
        $dataTable
            ->add('country', TextColumn::class)
            ->add('zip', TextColumn::class)
            ->add('city', TextColumn::class)
            ->add('street', TextColumn::class)

        ;

        parent::configure($dataTable, $options);

    }
}
