<?php

declare(strict_types=1);

namespace App\Table\Magazine;

use App\Table\Abstract\BaseTable;
use Omines\DataTablesBundle\Column\TextColumn;
use Omines\DataTablesBundle\Column\TwigStringColumn;
use Omines\DataTablesBundle\DataTable;

final class ArticleTable extends BaseTable
{
    public function configure(DataTable $dataTable, array $options): void
    {
        parent::preConfigure($dataTable, $options);
        $dataTable->add('publishedAt', TwigStringColumn::class, ['template' => '{{ row.publishedAt ? row.publishedAt|date("Y m. d. H:i") }}', 'searchable' => false]);
        parent::configure($dataTable, $options);
    }
}
