<?php

declare(strict_types=1);

namespace App\Table\Education;

use App\Table\Abstract\BaseTable;
use Omines\DataTablesBundle\Column\TwigStringColumn;
use Omines\DataTablesBundle\DataTable;

final class CategoryTable extends BaseTable
{
    public function configure(DataTable $dataTable, array $options): void
    {
        parent::preConfigure($dataTable, $options);
        $dataTable->add('startDate', TwigStringColumn::class, ['template' => '{{ row.translatable.startDate ? row.translatable.startDate|date("Y m. d.") }}', 'searchable' => false]);
        $dataTable->add('endDate', TwigStringColumn::class, ['template' => '{{ row.translatable.endDate ? row.translatable.endDate|date("Y m. d.") }}', 'searchable' => false]);
        parent::configure($dataTable, $options);
    }
}
