<?php

namespace App\Service\View;

use App\Service\View\Context\ViewContext;
use App\Service\View\Context\ViewContextInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Stopwatch\Stopwatch;

readonly class TraceableViewHandlerDecorator implements ViewHandlerInterface
{
    public function __construct(
        private ViewHandlerInterface $viewHandler,
        private Stopwatch            $stopwatch
    )
    {
    }

    public function handle(mixed $value, ViewContextInterface $context = new ViewContext()): Response
    {
        $event = $this->stopwatch->start('handle', 'view_handler');

        try {
            return $this->viewHandler->handle($value, $context);
        } finally {
            $event->stop();
        }
    }
}