<?php

namespace App\Service\View\Serializer\Exception;

use App\Exception\View\ConstraintViolationException;
use Symfony\Component\Serializer\Exception\PartialDenormalizationException;
use Symfony\Component\Validator\ConstraintViolation;
use Symfony\Component\Validator\ConstraintViolationList;
use Symfony\Contracts\Translation\TranslatorInterface;

readonly class PartialDenormalizationExceptionNormalizerDecorator implements ExceptionNormalizerInterface
{
    public function __construct(
        private ExceptionNormalizerInterface $normalizer,
        private TranslatorInterface $translator
    )
    {
    }

    public function supportsNormalization(mixed $data, string $format = null, array $context = []): bool
    {
        return $this->normalizer->supportsNormalization($data, $format, $context);
    }

    public function normalize(mixed $object, string $format = null, array $context = []): array
    {
        if ($object instanceof PartialDenormalizationException) {
            $violations = new ConstraintViolationList();

            $trans = $this->translator ? $this->translator->trans(...) : fn ($m, $p) => strtr($m, $p);

            foreach ($object->getErrors() as $error) {
                $parameters = ['{{ type }}' => implode('|', $error->getExpectedTypes())];

                if ($error->canUseMessageForUser()) {
                    $parameters['hint'] = $error->getMessage();
                }

                $template = 'This value should be of type {{ type }}.';
                $message = $trans($template, $parameters, 'validators');

                $violations->add(new ConstraintViolation($message, $template, $parameters, null, $error->getPath(), null));
            }

            $object = new ConstraintViolationException($violations);
        }

        return $this->normalizer->normalize($object, $format, $context);
    }
}