<?php

namespace App\Service\View\Serializer\Exception;

use Symfony\Component\Serializer\Exception\InvalidArgumentException;
use Throwable;

class ExceptionNormalizer implements ExceptionNormalizerInterface
{
    public function supportsNormalization(mixed $data, string $format = null, array $context = []): bool
    {
        return $data instanceof Throwable;
    }

    public function normalize(mixed $object, string $format = null, array $context = []): array
    {
        if (!$object instanceof Throwable) {
            throw new InvalidArgumentException('Object must be an instance of \'Throwable\'');
        }

        $detail = [
            'type' => get_class($object),
            'file' => $object->getFile(),
            'line' => $object->getLine(),
            'stacktrace' => $object->getTraceAsString()
        ];

        return [
            'status' => 500,
            'code' => $object->getCode(),
            'title' => $object->getMessage(),
            'detail' => json_encode($detail)
        ];
    }
}