<?php

namespace App\Service\View\Serializer\Exception;

readonly class AnonymizingExceptionNormalizerDecorator implements ExceptionNormalizerInterface
{
    public function __construct(
        private ExceptionNormalizerInterface $normalizer,
        private bool $shouldAnonymize
    )
    {
    }

    public function supportsNormalization(mixed $data, string $format = null, array $context = []): bool
    {
        return $this->normalizer->supportsNormalization($data, $format, $context);
    }

    public function normalize(mixed $object, string $format = null, array $context = []): array
    {
        $data = $this->normalizer->normalize($object, $format, $context);

        if ($this->shouldAnonymize) {
            $data['status'] = '';
            $data['title'] = '';
            $data['detail'] = '';
        }

        return $data;
    }
}