<?php

namespace App\Service\View\EventSubscriber;

use App\Service\View\Event\PreCreateResponseEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TotalItemsAddingEventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            PreCreateResponseEvent::class => ['handle', 30]
        ];
    }

    public function handle(PreCreateResponseEvent $event): void
    {
        $context = $event->getContext();

        $totalItems = $context->getExtra('totalItems');

        if ($totalItems !== null) {
            $meta = $context->getMember('meta', []);
            $meta['totalItems'] = $totalItems;
            $context->setMember('meta', $meta);
        }
    }
}