<?php

namespace App\Service\View\EventSubscriber;

use App\Service\View\Event\PreCreateResponseEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class PaginationContextAddingEventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            PreCreateResponseEvent::class => ['handle', 30]
        ];
    }

    public function handle(PreCreateResponseEvent $event): void
    {
        $context = $event->getContext();

        $paginationContext = $context->getExtra('pagination');

        if ($paginationContext !== null) {
            $meta = $context->getMember('meta', []);
            $meta['pagination'] = $paginationContext;
            $context->setMember('meta', $meta);
        }
    }
}