<?php

namespace App\Service\View\EventSubscriber;

use App\Service\View\Event\PreCreateResponseEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Exception\HttpExceptionInterface;
use Throwable;

class ExceptionResponseCodeSettingEventSubscriber implements EventSubscriberInterface
{

    public static function getSubscribedEvents(): array
    {
        return [
            PreCreateResponseEvent::class => 'handle'
        ];
    }

    public function handle(PreCreateResponseEvent $event): void
    {
        $context = $event->getContext();
        $statusCode = $context->getStatus();
        $value = $event->getValue();

        if ($value instanceof Throwable) {
            $statusCode = 500;

            if ($value instanceof HttpExceptionInterface) {
                $statusCode = $value->getStatusCode();
            }
        }

        $context->setStatus($statusCode);
    }
}