<?php

declare(strict_types=1);

namespace App\Service\System;


use App\Entity\Common\Meta\Meta;
use App\Repository\System\Webspace\WebspaceRepository;

final readonly class OwnerProvider
{
    public function __construct(
        private WebspaceRepository           $webspaceRepository,
    )
    {
    }

    public function get() : Meta
    {
        $webspace = $this->webspaceRepository->findOneByCode('default');

        return $webspace->getMeta();
    }

}
