<?php

declare(strict_types=1);

namespace App\Service\Social;

use App\Entity\User\User;
use League\OAuth2\Client\Provider\GoogleUser;

final class GoogleUserUpdater
{
    public function update(User $user, GoogleUser $googleUser): void
    {
        $user->setGoogleId($googleUser->getId());
        $user->setFirstName($googleUser->getFirstName());
        $user->setLastName($googleUser->getLastName());
        $user->setVerified(true);
    }
}
