<?php

declare(strict_types=1);

namespace App\Service\Social;

use KnpU\OAuth2ClientBundle\Client\OAuth2ClientInterface;
use KnpU\OAuth2ClientBundle\Client\Provider\GoogleClient as ProviderGoogleClient;
use League\OAuth2\Client\Provider\AbstractProvider;
use League\OAuth2\Client\Provider\Exception\IdentityProviderException;
use League\OAuth2\Client\Provider\GoogleUser;
use League\OAuth2\Client\Token\AccessToken;
use League\OAuth2\Client\Token\AccessTokenInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

final readonly class GoogleClient implements OAuth2ClientInterface
{
    public function __construct(
        private ProviderGoogleClient $providerGoogleClient
    )
    {
    }

    public function fetchUser(): GoogleUser
    {
        return $this->providerGoogleClient->fetchUser();
    }

    public function setAsStateless(): void
    {
        $this->providerGoogleClient->setAsStateless();
    }

    public function redirect(array $scopes, array $options): RedirectResponse
    {
        return new RedirectResponse(
            $this->getUrl()
        );
    }

    public function getUrl(): string
    {
        return $this->providerGoogleClient->getOAuth2Provider()->getAuthorizationUrl();
    }

    public function getOAuth2Provider(): AbstractProvider
    {
        return $this->providerGoogleClient->getOAuth2Provider();
    }

    public function getAccessToken(array $options = []): AccessToken|AccessTokenInterface
    {
        return $this->providerGoogleClient->getAccessToken($options);
    }

    public function fetchUserFromToken(AccessToken $accessToken): GoogleUser
    {
        return $this->providerGoogleClient->fetchUserFromToken($accessToken);
    }

    /**
     * @throws IdentityProviderException
     */
    public function refreshAccessToken(string $refreshToken, array $options = []): AccessToken
    {
        return $this->providerGoogleClient->refreshAccessToken($refreshToken, $options);
    }
}
