<?php

declare(strict_types=1);

namespace App\Service\Social;

use App\Entity\User\User;
use League\OAuth2\Client\Provider\FacebookUser;

final class FacebookUserUpdater
{
    public function update(User $user, FacebookUser $facebookUser): void
    {
        $user->setFacebookId($facebookUser->getId());
        $user->setFirstName($facebookUser->getFirstName());
        $user->setLastName($facebookUser->getLastName());
        $user->setVerified(true);
    }
}
