<?php

namespace App\Service\Layout\Widget\Page\PageMeta;

final readonly class PageMeta
{
    public function __construct(
        private ?string $title = null,
        private ?string $description = null,
        private array   $keywords = [],
    )
    {
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getKeywords(): array
    {
        return $this->keywords;
    }
}