<?php

namespace App\Service\Layout\Widget\Page;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\NodeCompilerInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

final readonly class PageCompiler implements NodeCompilerInterface
{
    public function __construct(
        private DenormalizerInterface $denormalizer
    )
    {
    }

    public function supports(Node $node, CompilerContext $context): bool
    {
        $properties = $node->getProperties();

        return $node->getType() === 'page'
            && (is_array($properties) || $properties instanceof PageProperties);
    }

    public function compile(Node $node, CompilerContext $context): Node
    {
        $properties = $node->getProperties();

        if (is_array($properties)) {
            $properties = $this->denormalizer->denormalize($properties, PageProperties::class);
        }

        return $node->setProperties($properties);
    }
}