<?php

namespace App\Service\Layout\Widget\Page\OpenGraph\Meta;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Exception\StampNotFoundException;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\Stamp\OpenGraphMetaStamp;
use App\Service\Layout\Compiler\StampProcessorInterface;
use App\Service\Layout\Widget\Page\PageProperties;

readonly class MetaStampProcessor implements StampProcessorInterface
{
    public function supports(Node $node, CompilerContext $context): bool
    {
        return $node->getType() === 'page'
            && $node->getProperties() instanceof PageProperties
            && $context->hasStamp(OpenGraphMetaStamp::class);
    }

    /**
     * @throws StampNotFoundException
     */
    public function process(Node $node, CompilerContext $context): Node
    {
        /** @var OpenGraphMetaStamp $stamp */
        $stamp = $context->getHighestPriorityStamp(OpenGraphMetaStamp::class);

        $meta = new Meta(
            $stamp->getSiteName(),
            $stamp->getTitle(),
            $stamp->getDescription(),
            $stamp->getType(),
            $stamp->getUrl()
        );

        /** @var PageProperties $properties */
        $properties = $node->getProperties();

        $openGraph = $properties->getOpenGraph();
        $openGraph = $openGraph->setMeta($meta);

        $properties = $properties->setOpenGraph($openGraph);

        return $node->setProperties($properties);
    }
}