<?php

namespace App\Service\Layout\Widget\Page\OpenGraph\Meta;

final readonly class Meta
{
    public function __construct(
        private ?string     $siteName,
        private ?string     $title,
        private ?string     $description,
        private ?ObjectType $type,
        private ?string     $url
    )
    {
    }

    public function getSiteName(): ?string
    {
        return $this->siteName;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getType(): ?ObjectType
    {
        return $this->type;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }
}