<?php

namespace App\Service\Layout\Widget\Page\OpenGraph\Article;

final readonly class Author
{
    public function __construct(
        private ?string $firstName,
        private ?string $lastName,
        private ?string $username,
        private ?Gender $gender
    )
    {
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function getUsername(): ?string
    {
        return $this->username;
    }

    public function getGender(): ?Gender
    {
        return $this->gender;
    }
}