<?php

namespace App\Service\Layout\Widget\Page\OpenGraph\Article;

use DateTimeInterface;

final readonly class Article
{
    /**
     * @param DateTimeInterface|null $publishedTime
     * @param DateTimeInterface|null $modifiedTime
     * @param DateTimeInterface|null $expirationTime
     * @param Author|null $author
     * @param string|null $section
     * @param array<string> $tag
     */
    public function __construct(
        private ?DateTimeInterface $publishedTime,
        private ?DateTimeInterface $modifiedTime,
        private ?DateTimeInterface $expirationTime,
        private ?Author            $author,
        private ?string            $section,
        private array              $tag
    )
    {
    }

    public function getPublishedTime(): ?DateTimeInterface
    {
        return $this->publishedTime;
    }

    public function getModifiedTime(): ?DateTimeInterface
    {
        return $this->modifiedTime;
    }

    public function getExpirationTime(): ?DateTimeInterface
    {
        return $this->expirationTime;
    }

    public function getAuthor(): ?Author
    {
        return $this->author;
    }

    public function getSection(): ?string
    {
        return $this->section;
    }

    /**
     * @return array<string>
     */
    public function getTag(): array
    {
        return $this->tag;
    }
}