<?php

namespace App\Service\Layout\Widget\ArticlePage;

use App\Service\Layout\Compiler\Context\CompilerContext;
use App\Service\Layout\Compiler\Node;
use App\Service\Layout\Compiler\NodeCompilerInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

readonly class ArticlePageCompiler implements NodeCompilerInterface
{
    public function __construct(
        private DenormalizerInterface $denormalizer
    )
    {
    }

    public function supports(Node $node, CompilerContext $context): bool
    {
        $properties = $node->getProperties();

        return $node->getType() === 'article_page'
            && (is_array($properties) || $properties instanceof ArticlePageProperties);
    }

    public function compile(Node $node, CompilerContext $context): Node
    {
        $properties = $node->getProperties();

        if (is_array($properties)) {
            $properties = $this->denormalizer->denormalize($properties, ArticlePageProperties::class);
        }

        // TODO: Get slug from context
        // TODO: Get article
        // TODO: Set properties

        return $node->setProperties($properties);
    }
}