<?php

namespace App\Service\Layout\Compiler;

use App\Service\Layout\Compiler\Context\CompilerContext;
use Symfony\Component\Stopwatch\Stopwatch;

final readonly class TraceableCompiler implements CompilerInterface
{
    public function __construct(
        private CompilerInterface $compiler,
        private Stopwatch         $stopwatch
    )
    {
    }

    public function compile(Node $node, CompilerContext $context): Node
    {
        $event = $this->stopwatch->start('app.compiler');

        try {
            return $this->compiler->compile($node, $context);
        } finally {
            $event->stop();
        }
    }
}