<?php

namespace App\Service\Layout\Compiler\Stamp;

use App\Helper\PrioritizableInterface;
use App\Service\Layout\Widget\Page\Twitter\CardType;

final readonly class TwitterMetaStamp implements StampInterface, PrioritizableInterface
{
    public function __construct(
        private ?CardType $cardType,
        private ?string   $site,
        private ?string   $creator,
        private int       $priority
    )
    {
    }

    public function getCardType(): ?CardType
    {
        return $this->cardType;
    }

    public function getSite(): ?string
    {
        return $this->site;
    }

    public function getCreator(): ?string
    {
        return $this->creator;
    }

    public function getPriority(): int
    {
        return $this->priority;
    }
}