<?php

namespace App\Service\Layout\Compiler\Stamp;

final class StampQueue
{
    private array $stamps = [];

    public function getAll(): array
    {
        return array_reduce($this->stamps, static function (array $aggregator, $stamps) {
            array_push($aggregator, ...$stamps);

            return $aggregator;
        }, []);
    }

    public function getLast(string $class): ?StampInterface
    {
        $stamps = $this->get($class);

        $lastKey = max(0, array_keys($stamps));

        return $stamps[$lastKey] ?? null;
    }

    public function get(string $class): array
    {
        return $this->stamps[$class] ?? [];
    }

    public function add(StampInterface $stamp): void
    {
        $class = get_class($stamp);

        $this->stamps[$class][] = $stamp;
    }

    public function has(string $class): bool
    {
        return array_key_exists($class, $this->stamps);
    }
}