<?php

namespace App\Service\Layout\Compiler\Stamp;

use App\Helper\PrioritizableInterface;

final readonly class PageMetaStamp implements StampInterface, PrioritizableInterface
{
    /**
     * @param string $title
     * @param string $description
     * @param array<string> $keywords
     * @param int $priority
     */
    public function __construct(
        private string $title,
        private string $description,
        private array  $keywords,
        private int    $priority
    )
    {
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return array<string>
     */
    public function getKeywords(): array
    {
        return $this->keywords;
    }

    public function getPriority(): int
    {
        return $this->priority;
    }
}