<?php

namespace App\Service\Layout\Compiler;

use JetBrains\PhpStorm\Immutable;

#[Immutable]
readonly class Node
{
    public function __construct(
        private string                    $type,
        private array|PropertiesInterface $properties = [],
        private array                     $children = []
    )
    {
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getProperties(): PropertiesInterface|array
    {
        return $this->properties;
    }

    public function setProperties(PropertiesInterface|array $properties): self
    {
        return new self(
            $this->type,
            $properties,
            $this->children
        );
    }

    public function getChildren(): array
    {
        return $this->children;
    }

    /**
     * @param array<Node> $children
     */
    public function setChildren(array $children): self
    {
        return new self(
            $this->type,
            $this->properties,
            $children
        );
    }
}