<?php

namespace App\Service\Layout\Compiler\Context;

use App\Helper\PriorityQueue;
use App\Service\Layout\Compiler\Enum\CompileMode;
use App\Service\Layout\Compiler\Exception\StampNotFoundException;
use App\Service\Layout\Compiler\Stamp\StampInterface;
use App\Service\Layout\Compiler\Stamp\StampQueue;
use DateTimeInterface;

readonly class CompilerContext
{
    public function __construct(
        private CompileMode       $mode,
        private DateTimeInterface $time,
        private StampQueue        $stampQueue
    )
    {
    }

    public function getMode(): CompileMode
    {
        return $this->mode;
    }

    public function getTime(): DateTimeInterface
    {
        return $this->time;
    }

    public function getStamps(string $class): array
    {
        return $this->stampQueue->get($class);
    }

    /**
     * @throws StampNotFoundException
     */
    public function getHighestPriorityStamp(string $class): StampInterface
    {
        $stamps = $this->stampQueue->get($class);
        $priorityQueue = new PriorityQueue($stamps);

        return $priorityQueue->getTopEntry()->getValue() ?: throw new StampNotFoundException($class);
    }

    public function hasStamp(string $class): bool
    {
        return $this->stampQueue->has($class);
    }

    public function addStamp(StampInterface $stamp): void
    {
        $this->stampQueue->add($stamp);
    }
}