<?php

declare(strict_types=1);

namespace App\Repository\System\Webspace;

use App\Entity\System\Webspace\Config;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class ConfigRepository extends ServiceEntityRepository
{
    use Editable;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Config::class);
    }

    public function findAllByWebspace($locale, $webspace): array
    {
        return $this->createQueryBuilder('c')
            ->leftJoin('c.translations', 'trans')
            ->leftJoin('c.webspace', 'w')
            ->andWhere('w.id = :webspace')
            ->andWhere('trans.locale = :locale')
            ->setParameter('locale', $locale)
            ->setParameter('webspace', $webspace)
            ->getQuery()
            ->getResult();
    }

}
