<?php

declare(strict_types=1);

namespace App\Repository\Shared;

use App\Service\Pagination\Context\PaginationContext;
use Doctrine\ORM\QueryBuilder;

trait PaginationAwareRepositoryTrait
{
    public function applyPagination(QueryBuilder $queryBuilder, ?PaginationContext $paginationContext): void
    {
        if (!$paginationContext instanceof PaginationContext) {
            return;
        }

        $queryBuilder
            ->setMaxResults($paginationContext->getItemsPerPage())
            ->setFirstResult($paginationContext->getItemsPerPage() * ($paginationContext->getPage() - 1));
    }
}
