<?php

declare(strict_types=1);

namespace App\Repository\Education;

use App\Entity\Education\Exam\Exam;
use App\Repository\Shared\PaginationAwareRepositoryTrait;
use App\Service\Pagination\Context\PaginationContext;
use App\Traits\Repository\Editable;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

final class ExamRepository extends ServiceEntityRepository
{
    use Editable;

    public function __construct(ManagerRegistry $managerRegistry)
    {
        parent::__construct($managerRegistry, Exam::class);
    }

    public function findPublics($locale): array
    {
        $queryBuilder = $this->createQueryBuilder('a')
            ->addSelect('at')
            ->leftJoin('a.translations', 'at')
            ->andWhere('at.locale = :locale')
            ->andWhere('at.isActive = true')
            ->orderBy('at.createdAt', 'DESC')
            ->setParameter('locale', $locale);

        return $queryBuilder
            ->getQuery()
            ->getResult();
    }

    public function findOneBySlug($locale, $slug): ?Exam
    {
        return $this->createQueryBuilder('a')
            ->leftJoin('a.translations', 'trans')
            ->andWhere('trans.slug = :slug')
            ->andWhere('trans.locale = :locale')
            ->setMaxResults(1)
            ->setParameter('slug', $slug)
            ->setParameter('locale', $locale)
            ->getQuery()
            ->getOneOrNullResult();

    }


    public function getChart(): ?array
    {
        return $this->createQueryBuilder('e')
            ->select("DATE_FORMAT(e.createdAt, '%Y-%m') as x, COUNT(e) as count")
            ->groupBy('x')
            ->addOrderBy('x', 'ASC')
            ->getQuery()->getResult();
    }
}
